﻿//////////////////////////////////////////////
// WindowingSystem.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkWinUi
{
	class Component ;
	class ComponentUtils ;
	class DataAllocator ;
	class InputProcessor ;
	class System ;
}

/// Includes ---------------------------------

// nkWinUi
#include "../Dll/DllDefines.h"

/// Internals --------------------------------

namespace nkWinUi
{
	enum class SYSTEM_TYPE
	{
		UNKNOWN = 0,
		WIN_API

		#if defined(__EMSCRIPTEN__)
			, JS_DOM
		#endif
	} ;
}

/// Class ------------------------------------

namespace nkWinUi
{
	class DLL_WINUI_EXPORT WindowingSystem
	{
		public :

			// Constructor, destructor
			WindowingSystem (System* system) noexcept ;
			virtual ~WindowingSystem () ;

			// Getters
			DataAllocator* getAllocator () const ;
			ComponentUtils* getComponentUtils () const ;
			InputProcessor* getInputProcessor () const ;
			SYSTEM_TYPE getSystemType () const ;

			// Initialization
			virtual bool load () = 0 ;

			// Run
			virtual void run () = 0 ;
			virtual void tick () = 0 ;

			// Shut down
			virtual void prepareForShutdown () = 0 ;
			virtual void shutdown () = 0 ;

			// Poke
			virtual void notifyEvent () = 0 ;
			
		protected :

			// Attributes
			// Parent system
			System* _system ;

			// Component allocator
			DataAllocator* _allocator ;

			// Utility to manipulate them
			ComponentUtils* _componentUtils ;

			// Internal input processor
			InputProcessor* _inputProcessor ;

			// And its type
			SYSTEM_TYPE _systemType ;
	} ;
}